#ifndef __C4DBASETAG_H
#define __C4DBASETAG_H

#include "c4d_baselist.h"
#include "operatingsystem.h"
#include "ge_vector.h"

class BaseObject;
class BaseSelect;
class GvNodeMaster;

#define TAG_VISIBLE								(1<<0)
#define TAG_MULTIPLE							(1<<1)
#define TAG_HIERARCHICAL					(1<<2)
#define TAG_EXPRESSION						(1<<3)

class BaseTag : public BaseList2D
{
	private:
		BaseTag(void);
	public:
		BaseObject *GetObject(void) { return (BaseObject*)AtCall(GetMain)(); }

		BaseTag *GetNext(void) { return (BaseTag*)AtCall(GetNext)(); }
		BaseTag *GetPred(void) { return (BaseTag*)AtCall(GetPred)(); }

		static BaseTag *Alloc(LONG type);
		static void Free(BaseTag *&bl);
};

class PluginTag : public BaseTag
{
	public:
		static PluginTag *Alloc(LONG type);
		static void Free(PluginTag *&key);
};

class VariableTag : public BaseTag
{
	private:
		VariableTag(void);
	public:
		LONG 				GetDataCount	(void);
		LONG 				GetDataSize		(void);
		void 			 *GetDataAddress(void);

		static VariableTag *Alloc(LONG type, LONG count);
		static void Free(VariableTag *&bl);
};

class SelectionTag : public BaseTag
{
	private:
		SelectionTag(void);
	public:
		BaseSelect *GetBaseSelect(void);

		static SelectionTag *Alloc(LONG type);
		static void Free(SelectionTag *&bl);
};

struct UVWStruct
{
	UVWStruct(void) {}
	UVWStruct(const Vector &t_a, const Vector &t_b, const Vector &t_c, const Vector &t_d) { a=t_a; b=t_b; c=t_c; d=t_d; }
	UVWStruct(const Vector &t_a, const Vector &t_b, const Vector &t_c) { a=t_a; b=t_b; c=t_c; }

	Vector a,b,c,d;
};

class UVWTag : public VariableTag
{
	private:
		UVWTag(void);
	public:
		UVWStruct Get(LONG i) { UVWStruct us; C4DOS.Tg->UvGet(this,i,&us); return us; }
		void Set(LONG i, const UVWStruct &s) { C4DOS.Tg->UvSet(this,i,(UVWStruct*) &s); }
		void Cpy(LONG dst, UVWTag *srctag, LONG src) { C4DOS.Tg->UvCpy(this,dst,srctag,src); }

		static UVWTag *Alloc(LONG count);
		static void Free(UVWTag *&bl);
};

class TextureTag : public BaseTag
{
	private:
		TextureTag(void);
	public:
		Vector GetPos(void);
		Vector GetScale(void);
		Vector GetRot(void);
		Matrix GetMl(void);
		Matrix GetMln(void);
		void SetPos(const Vector &v);
		void SetScale(const Vector &v);
		void SetRot(const Vector &v);
		void SetMl(const Matrix &m);

		BaseMaterial *GetMaterial(void);
		void SetMaterial(BaseMaterial *mat);

		static TextureTag *Alloc();
		static void Free(TextureTag *&bl);
};

class StickTextureTag : public VariableTag
{
	private:
		StickTextureTag(void);
	public:
		Bool Record(BaseObject *op, Bool always);

		static StickTextureTag *Alloc(LONG type);
		static void Free(StickTextureTag *&bl);
};

class XPressoTag : public BaseTag
{
	private:
		XPressoTag(void);
	public:
		GvNodeMaster *GetNodeMaster(void);

		static XPressoTag *Alloc();
		static void Free(XPressoTag *&bl);
};

struct PolyWeight
{
  Real a, b, c, d; // weights of the edges, (for triangles a, b and d contain vaild data)
};

struct HNData
{
  LONG *points, *polys;
  Real **pointweight;
  PolyWeight **polyweight;
  Bool *changed;
};

class HNWeightTag : public PluginTag
{
  private:
    HNWeightTag(void);
  public:
    Bool GetTagData(HNData* data); // fills the members of this class

		static HNWeightTag *Alloc();
		static void Free(HNWeightTag *&bl);
};

#define BAKEPARTICLETAG_FROM						1001 // LONG
#define BAKEPARTICLETAG_TO							1002 // LONG
#define BAKEPARTICLETAG_STEP						1003 // LONG
#define BAKEPARTICLETAG_IGNORE					1004 // BOOL

#endif
